<?php

if (isset($_POST['tgl']))
{
$tgl = strtotime($_POST['tgl']);

include "icalendar.class.php";
$acalend = new ICalendar();

$hari7 = strtotime("+6 days", $tgl);
$hari40 = strtotime("+39 days", $tgl);
$pendak1 = getPendak($tgl, strtotime("+350 days", $tgl));
$pendak2 = getPendak($tgl, strtotime("+350 days", $pendak1));
$hari100 = strtotime("+99 days", $tgl);
$hari1000 = strtotime("+999 days", $tgl);

    $hari = array();
    $hari[] = showTanggal($tgl, "Hari H");
    $hari[] = showTanggal($hari7, "Hari 7");
    $hari[] = showTanggal($hari40, "Hari 40");
    $hari[] = showTanggal($hari100, "Hari 100");
    $hari[] = showTanggal($pendak1, "Pendak Pisan");
    $hari[] = showTanggal($pendak2, "Pendak Pindo");
    $hari[] = showTanggal($hari1000, "Hari 1000");
    
    echo "
<table border='1'>
<tr><th>Event</th><th>Hari</th><th>Masehi</th><th>Hijriyah</th></tr>";
foreach($hari as $item)
{
    list($jenis, $hr, $masehi, $hijriyah) = $item;
    echo "<tr>
<td><strong>$jenis</strong></td><td>$hr</td><td>$masehi</td><td>$hijriyah</td>
</tr>";
}
    echo "</table>";
echo "<hr/>";

}

echo <<< EOT
<form method='post'>
Masukkan Tanggal: 
<input type='text' name='tgl' value='$_POST[tgl]' />
<input type='submit' value='Proses' />
</form>
EOT;

function getPendak($tgl1, $tgl2)
{
    global $acalend;    

    $hijri = $acalend->GregorianToIslamic(date("Y", $tgl1), date("n", $tgl1), date("j", $tgl1));
    $mendak = $acalend->GregorianToIslamic(date("Y", $tgl2), date("n", $tgl2), date("j", $tgl2));
    while (($hijri['month'] != $mendak['month']) || ($hijri['day'] != $mendak['day']))
    {
        if ($hijri['month'] < $mendak['month'])
        {
            $tgl2 = strtotime("-1 day", $tgl2);
        }
        else
        if ($hijri['month'] > $mendak['month'])
        {
            $tgl2 = strtotime("+1 day", $tgl2);
        }
        else
        if ($hijri['day'] < $mendak['day'])
        {
            $tgl2 = strtotime("-1 day", $tgl2);
        }
        else
        if ($hijri['day'] > $mendak['day'])
        {
            $tgl2 = strtotime("+1 day", $tgl2);
        }        
        $mendak = $acalend->GregorianToIslamic(date("Y", $tgl2), date("n", $tgl2), date("j", $tgl2));
    }
    return $tgl2;
}

function showTanggal($tgl, $jenis)
{
    global $acalend;    

    $GDay = date("j", $tgl);
    $GMonth = date("n", $tgl);
    $GYear = date("Y", $tgl);
	
    $acdate = $acalend->GregorianToIslamic($GYear, $GMonth, $GDay);
	
	
    $jour=$acdate[dayname];
    $ADay = $acdate[day];
    $AMonth = $acdate[monthname];
    $AYear = $acdate[year];

    return array($jenis, namaHari($tgl) . " " . namaPasaran($tgl),  $GDay . " " . namaBulan($tgl) . " " . date("Y", $tgl), "$ADay $AMonth $AYear");
}

function namaHari($tgl)
{
        $namahari = array("Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jum'at", "Sabtu");
        return $namahari[date("w", $tgl)];
}

function namaPasaran($tgl)
{
        $pasaran = array("", "Legi", "Pahing", "Pon", "Wage", "Kliwon");

        $pasaranlookup = Array();
        $pasaranlookup[1]  = array(1, 2, 1, 2, 2, 3, 3, 4, 0, 0, 1, 1);
        $pasaranlookup[2]  = array(2, 3, 1, 2, 2, 3, 3, 4, 0, 0, 1, 1);
        $pasaranlookup[3]  = array(2, 3, 1, 2, 2, 3, 3, 4, 0, 0, 1, 1);
        $pasaranlookup[4]  = array(2, 3, 1, 2, 2, 3, 3, 4, 0, 0, 1, 1);
        $pasaranlookup[5]  = array(2, 3, 2, 3, 3, 4, 4, 0, 1, 1, 2, 2);
        $pasaranlookup[6]  = array(3, 4, 2, 3, 3, 4, 4, 0, 1, 1, 2, 2);
        $pasaranlookup[7]  = array(3, 4, 2, 3, 3, 4, 4, 0, 1, 1, 2, 2);
        $pasaranlookup[8]  = array(3, 4, 2, 3, 3, 4, 4, 0, 1, 1, 2, 2);
        $pasaranlookup[9]  = array(3, 4, 3, 4, 4, 0, 0, 1, 2, 2, 3, 3);
        $pasaranlookup[10] = array(4, 0, 3, 4, 4, 0, 0, 1, 2, 2, 3, 3);
        $pasaranlookup[11] = array(4, 0, 3, 4, 4, 0, 0, 1, 2, 2, 3, 3);
        $pasaranlookup[12] = array(4, 0, 3, 4, 4, 0, 0, 1, 2, 2, 3, 3);
        $pasaranlookup[13] = array(4, 0, 4, 0, 0, 1, 1, 2, 3, 3, 4, 4);
        $pasaranlookup[14] = array(0, 1, 4, 0, 0, 1, 1, 2, 3, 3, 4, 4);
        $pasaranlookup[15] = array(0, 1, 4, 0, 0, 1, 1, 2, 3, 3, 4, 4);
        $pasaranlookup[16] = array(0, 1, 4, 0, 0, 1, 1, 2, 3, 3, 4, 4);
        $pasaranlookup[17] = array(0, 1, 0, 1, 1, 2, 2, 3, 4, 4, 0, 0);
        $pasaranlookup[18] = array(1, 2, 0, 1, 1, 2, 2, 3, 4, 4, 0, 0);
        $pasaranlookup[19] = array(1, 2, 0, 1, 1, 2, 2, 3, 4, 4, 0, 0);
        $pasaranlookup[20] = array(1, 2, 0, 1, 1, 2, 2, 3, 4, 4, 0, 0);

        $tempyear = date("Y", $tgl) + 17;
        if ($tempyear % 20 == 0) {
           $valplookup = $pasaranlookup[20][date("m", $tgl)-1];}
                else {
           $valplookup = $pasaranlookup[$tempyear % 20][date("m", $tgl)-1];}

           $valplookupday = $valplookup + date("d", $tgl);
           if ($valplookupday > 5) {
                        if ($valplookupday % 5 == 0) {
                                $pasarane = $pasaran[5];}
                        else {
                                $pasarane = $pasaran[($valplookupday % 5)];}
                        }
                else {
                        $pasarane = $pasaran[$valplookupday];}

                return $pasarane;
}

function namaBulan($tgl)
{
        $namabulan = array("Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli",
                           "Agustus", "September", "Oktober", "November", "Desember");
        return $namabulan[date("n", $tgl) - 1];
}

?>