/*
 * Decompiled with CFR 0.152.
 */
package com.stardev.pasaran;

import com.stardev.pasaran.Hijriah;
import com.stardev.pasaran.Tanggal;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class Pasaran
extends MIDlet {
    Display display;
    StringItem hasil = new StringItem("Neptu:", "");
    StringItem hasil2 = new StringItem("Setelah Maghrib:", "");
    StringItem hasil3 = new StringItem("Perhitungan:", "");
    StringItem infostr = new StringItem("Informasi:", "\nAryo Sanjaya (aryo@aryosanjaya.net)\nhttp://www.mahesajenar.com/");
    Calendar cal = Calendar.getInstance();
    final long MILLIS_PER_DAY;
    Date tmpdt = new Date();

    public Pasaran() {
        this.MILLIS_PER_DAY = 86400000L;
        this.display = Display.getDisplay((MIDlet)this);
    }

    public void destroyApp(boolean unconditional) {
        this.notifyDestroyed();
    }

    public void pauseApp() {
        this.display = null;
    }

    public void commandAction(Command c, Displayable d) {
        this.destroyApp(true);
    }

    public void startApp() {
        Form form = new Form("Mencari Pasaran");
        ItemStateListener listener = new ItemStateListener(){

            public void itemStateChanged(Item item) {
                Pasaran.this.tmpdt = ((DateField)item).getDate();
                Pasaran.this.cal.setTime(Pasaran.this.tmpdt);
                Pasaran.this.hasil.setText(Pasaran.this.hitung(Pasaran.this.cal));
                Pasaran.this.tmpdt.setTime(Pasaran.this.tmpdt.getTime() + 86400000L);
                Pasaran.this.cal.setTime(Pasaran.this.tmpdt);
                Pasaran.this.hasil2.setText(Pasaran.this.hitung(Pasaran.this.cal));
                Pasaran.this.tmpdt.setTime(Pasaran.this.tmpdt.getTime() - 86400000L);
                Pasaran.this.cal.setTime(Pasaran.this.tmpdt);
                Pasaran.this.Perhitungan();
            }
        };
        CommandListener cmd_listener = new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                Pasaran.this.destroyApp(true);
            }
        };
        form.setItemStateListener(listener);
        form.setCommandListener(cmd_listener);
        Date now = new Date();
        DateField dateItem = new DateField("Masukkan Tanggal:", 1);
        dateItem.setDate(now);
        form.append((Item)dateItem);
        form.append((Item)this.hasil);
        form.append((Item)this.hasil2);
        form.append((Item)this.hasil3);
        form.append((Item)this.infostr);
        this.hasil.setText(this.hitung(this.cal));
        now.setTime(now.getTime() + 86400000L);
        this.cal.setTime(now);
        this.hasil2.setText(this.hitung(this.cal));
        form.addCommand(new Command("Keluar", 7, 1));
        this.display.setCurrent((Displayable)form);
        now.setTime(now.getTime() - 86400000L);
        this.cal.setTime(now);
        this.Perhitungan();
    }

    void Perhitungan() {
        Tanggal tgl = new Tanggal(this.cal.get(5), this.cal.get(2) + 1, this.cal.get(1));
        Tanggal tglpendak = new Tanggal(tgl.tgl, tgl.bln, tgl.thn);
        tglpendak.setTahun(0);
        String result = "\nHari ke-7: " + this.shiftTanggal(6);
        result = result + "\nHari ke-40: " + this.shiftTanggal(39);
        result = result + "\nHari ke-100: " + this.shiftTanggal(99);
        result = result + "\nHari ke-1000: " + this.shiftTanggal(999);
        result = result + "\nPendak Tahun Ini: " + Hijriah.getPendak(tgl, tglpendak);
        tglpendak.shiftTanggal(0, 0, 360);
        result = result + "\nPendak Tahun Depan: " + Hijriah.getPendak(tgl, tglpendak);
        this.hasil3.setText(result);
    }

    public String shiftTanggal(int num) {
        Calendar c = Calendar.getInstance();
        Date ldate = new Date();
        ldate.setTime(this.tmpdt.getTime() + 86400000L * (long)num);
        c.setTime(ldate);
        int tanggal = c.get(5);
        String hari = Hijriah.getDina(tanggal, c.get(2) + 1, c.get(1));
        String pasaran = Hijriah.getPasaran(tanggal, c.get(2) + 1, c.get(1));
        String bulan = Hijriah.namabulan[c.get(2)];
        int tahun = c.get(1);
        Hijriah.GregorianToIslamic(tahun, c.get(2) + 1, tanggal);
        return hari + " " + pasaran + ", " + tanggal + " " + bulan + " " + tahun + "\n" + Hijriah.day + " " + Hijriah.monthname + " " + Hijriah.year + " H";
    }

    String hitung(Calendar tgl) {
        int thedate = tgl.get(5);
        int themonth = tgl.get(2) + 1;
        int theyear = tgl.get(1);
        String dina = Hijriah.getDina(thedate, themonth, theyear);
        String pasaran = Hijriah.getPasaran(thedate, themonth, theyear);
        int neptudino = Hijriah.getNeptuDino(dina);
        int neptupasar = Hijriah.getNeptuPasar(pasaran);
        Hijriah.GregorianToIslamic(theyear, themonth, thedate);
        int neptu = neptudino + neptupasar;
        return "\nHari: " + dina + " (" + neptudino + ")\nPasaran: " + pasaran + " (" + neptupasar + ")\nNeptu: " + neptu + "\nHijriah: " + Hijriah.getHasil();
    }
}

